'use strict'

entityRegistry['module']['noise'] = {
    extendedInfo: {
        displayName: 'Noise',
        displayGroup: 'Post Processing',
    },
    init: (staticConfig) => {
        const {
            seed,
            bufferSize,
        } = { ...staticConfig}
        const noise = []
        const rng = new Math.seedrandom(seed)
        for (let i = 0; i < bufferSize; ++i) {
            noise.push(rng())
        }
        return {
            noise
        }
    },
    staticConfig: [
        { paramName: 'seed', displayName: 'Seed', type: 'string', defaultValue: 'seed', triggerInit: true },
        { paramName: 'bufferSize', displayName: 'Buffer Size', type: 'int', defaultValue: 1000, triggerInit: true },
    ],
    dynamicConfig: [
        { paramName: 'strength', displayName: 'Strength', type: 'float', defaultValue: 1},
        // { paramName: 'imageMask', displayName: 'Image Mask', type: 'colorTexture', defaultValue: ''},
    ],
    actions: {
        'render': (self, frameTime, config, ctx) => {
            const {
                strength,
                // imageMask,
            } = { ...config }

            const brightnessBuffer = renderer.getCurrentBuffer('brightness')
            const brightnessBufferData = brightnessBuffer.data
            const width = brightnessBuffer.width
            const height = brightnessBuffer.height
            // const maskImage = imageMask.data

            const rng = new Math.seedrandom()
            let srcIndex = Math.floor((rng() * self.noise.length) % self.noise.length)
            let dstIndex = 0
            for (let y = 0; y < height; ++y) {
                for (let x = 0; x < width; x++) {
                    if (brightnessBufferData[dstIndex] > 0) {
                        const pixelStrength = strength //* maskImage[dstIndex*4+3]/255
                        // if (pixelStrength > 0) {
                            brightnessBufferData[dstIndex] += self.noise[srcIndex] * pixelStrength
                        // }
                    }
                    srcIndex = (srcIndex+1) % self.noise.length
                    dstIndex++
                }
            }
        }
    }
}
